package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.Prestamo;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class PagosAdapter extends RecyclerView.Adapter<PagosAdapter.PagosViewHolder>{

    Context context;
    ArrayList<Pago> pagos;
    private SharedPreferences sesion;
    Prestamo prestamo;

    public ArrayList<Pago> pagosSeleccionados = new ArrayList<>();

    public PagosAdapter(Context context, ArrayList<Pago> pagos, Prestamo prestamo) {
        this.context = context;
        this.pagos = pagos;
        this.prestamo = prestamo;
    }

    @NonNull
    @Override
    public PagosAdapter.PagosViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(context).inflate(R.layout.pago_item_4, parent, false);
        return new PagosAdapter.PagosViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull PagosAdapter.PagosViewHolder holder, int position) {
        holder.imprimir(position);
    }

    @Override
    public int getItemCount() {
        return pagos.size();
    }

    public void clear() {
        pagos.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<Pago> list) {
        pagos = list;
        notifyDataSetChanged();
    }

    public class PagosViewHolder extends RecyclerView.ViewHolder {

        TextView tvSemanaPago, tvSemanalPago, tvFechaPago, tvFolioPago, tvPendiente;
        ConstraintLayout pago_item_bg;
        Button btnPagar, btnPagarConMulta, btnNoPagar;

        String informacion = "";

        public PagosViewHolder(@NonNull View itemView) {
            super(itemView);

            tvSemanaPago = itemView.findViewById(R.id.semanaPago);
            tvSemanalPago = itemView.findViewById(R.id.semanalPago);
            tvFechaPago = itemView.findViewById(R.id.fechaPago);
            tvFolioPago = itemView.findViewById(R.id.folioPago);
            pago_item_bg = itemView.findViewById(R.id.pago_item_bg);
            tvPendiente = itemView.findViewById(R.id.pendiente);
            /*btnPagar = itemView.findViewById(R.id.btnPagar);
            btnPagarConMulta = itemView.findViewById(R.id.btnPagarConMulta);
            btnNoPagar = itemView.findViewById(R.id.btnNoPagar);*/


        }

        public void imprimir(int position) {

            String fecha = pagos.get(position).getFecha_pago().split("-")[2] + "/" + pagos.get(position).getFecha_pago().split("-")[1] + "/"
            + pagos.get(position).getFecha_pago().split("-")[0];

            String pagado = String.valueOf(Utils.convertirDouble(pagos.get(position).getCantidad_normal_pagada()) + Utils.convertirDouble(pagos.get(position).getCantidad_multa()));

            tvSemanaPago.setText("Semana " + pagos.get(position).getSemana());
            tvSemanalPago.setText("$"+ pagado + " / $"
                    + pagos.get(position).getCantidad_esperada_pago());
            tvFechaPago.setText(fecha);

            if(pagos.get(position).getFolio() != null && !pagos.get(position).getFolio().equals("0") ){
                tvSemanaPago.setText("Semana " + pagos.get(position).getSemana() + " (" +pagos.get(position).getFolio()+")");

                pago_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                    @Override
                    public boolean onLongClick(View view) {

                        new MaterialAlertDialogBuilder(context)
                                .setTitle("Concepto de pago (" + pagos.get(position).getFolio()+")")
                                .setMessage(pagos.get(position).getConcepto() +"\n \nPAGO REALIZADO: "+pagos.get(position).getFecha_pago_realizada())
                                .setPositiveButton("Cerrar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                    }
                                })
                                .show();
                        return false;
                    }
                });
            }


            if(!pagos.get(position).getCantidad_pendiente().equals("0.00")){
                tvPendiente.setVisibility(View.VISIBLE);
                tvPendiente.setText("Pendiente: $" + pagos.get(position).getCantidad_pendiente());
            }
            else{
                tvPendiente.setVisibility(View.GONE);
            }

            /*if(!pagos.get(position).getCantidad_pendiente().equals("0.00")){

            }*/

            if(pagos.get(position).isSelected()){
                pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
            }

            if(pagos.get(position).getStatus().equals("0") || pagos.get(position).getStatus().equals("-1")
                    || pagos.get(position).getStatus().equals("1") && !pagos.get(position).getCantidad_pendiente().equals("0.00")){


                if(pagos.get(position).isSelected()){
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                    tvSemanaPago.setTextColor(context.getResources().getColor(R.color.black));
                    tvSemanalPago.setTextColor(context.getResources().getColor(R.color.black));
                    tvFechaPago.setTextColor(context.getResources().getColor(R.color.black));
                    tvPendiente.setTextColor(context.getResources().getColor(R.color.black));
                }else{
                    if(pagos.get(position).getStatus().equals("-1")){
                        pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.danger_custom));
                        tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                        tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                        tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                        tvPendiente.setTextColor(context.getResources().getColor(R.color.white));

                    }
                    else if(pagos.get(position).getStatus().equals("1")){
                        pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.success_custom));
                        tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                        tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                        tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                        tvPendiente.setTextColor(context.getResources().getColor(R.color.white));

                    }
                    else{
                        pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
                        tvSemanaPago.setTextColor(context.getResources().getColor(R.color.black));
                        tvSemanalPago.setTextColor(context.getResources().getColor(R.color.black));
                        tvFechaPago.setTextColor(context.getResources().getColor(R.color.black));
                        tvPendiente.setTextColor(context.getResources().getColor(R.color.black));

                    }


                }


                pago_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                    @Override
                    public boolean onLongClick(View view) {


                        if (pagos.get(position).isSelected()) {
                            pagos.get(position).setSelected(false);
                            if(pagos.get(position).getStatus().equals("-1")){
                                tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                                tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                                tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                                tvPendiente.setTextColor(context.getResources().getColor(R.color.white));
                                pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.danger_custom));
                            }
                            else if(pagos.get(position).getStatus().equals("1")){
                                tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                                tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                                tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                                tvPendiente.setTextColor(context.getResources().getColor(R.color.white));
                                pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.success_custom));
                            }
                            else {
                                pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
                            }
                            pagosSeleccionados.remove(pagos.get(position));
                        } else {
                            pagos.get(position).setSelected(true);
                            pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                            tvSemanaPago.setTextColor(context.getResources().getColor(R.color.black));
                            tvSemanalPago.setTextColor(context.getResources().getColor(R.color.black));
                            tvFechaPago.setTextColor(context.getResources().getColor(R.color.black));
                            tvPendiente.setTextColor(context.getResources().getColor(R.color.black));
                            pagosSeleccionados.add(pagos.get(position));
                        }


                        //pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.warning_light));

                        /*String[] items = {"Pagar", "No pagar"};
                        final String[] selected = {""};

                         new MaterialAlertDialogBuilder(context)
                                .setTitle("Semana " + pagos.get(position).getSemana())
                                .setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                        if(selected[0].equals("Pagar")){
                                            Bundle args = new Bundle();
                                            String pagoJsonString = Utils.getGsonParser().toJson(pagos.get(position));
                                            String prestamoJsonString = Utils.getGsonParser().toJson(prestamo);
                                            args.putString("pago", pagoJsonString);
                                            args.putString("prestamo", prestamoJsonString);


                                            Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                                    .navigate(R.id.nav_pagos_pagar, args);
                                        }
                                        else{
                                            noPagar(pagos.get(position).getId(), "0", pagos.get(position).getSemana());
                                        }

                                    }
                                })
                                 .setSingleChoiceItems(items, -1, new DialogInterface.OnClickListener() {
                                     @Override
                                     public void onClick(DialogInterface dialogInterface, int i) {
                                         selected[0] = items[i];
                                     }
                                 })
                                .show();*/
                        return false;
                    }
                });

                /*btnPagarConMulta.setVisibility(View.VISIBLE);
                btnNoPagar.setVisibility(View.VISIBLE);
                btnPagar.setVisibility(View.VISIBLE);*/
            }
            else if(pagos.get(position).getStatus().equals("1")){

                if(pagos.get(position).isSelected()){
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                }else{
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.success_custom));
                }

                tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvPendiente.setTextColor(context.getResources().getColor(R.color.white));

                /*btnPagarConMulta.setVisibility(View.GONE);
                btnNoPagar.setVisibility(View.GONE);
                btnPagar.setVisibility(View.GONE);*/

            }
            else if(pagos.get(position).getStatus().equals("2")){

                if(pagos.get(position).isSelected()){
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                }else {
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.info_custom));
                }

                tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvPendiente.setTextColor(context.getResources().getColor(R.color.white));

                /*btnPagarConMulta.setVisibility(View.GONE);
                btnNoPagar.setVisibility(View.GONE);
                btnPagar.setVisibility(View.GONE);*/

            }
            else if(pagos.get(position).getStatus().equals("3")){

                if(pagos.get(position).isSelected()){
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                }else {
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.warning_custom));
                }

                tvSemanaPago.setTextColor(context.getResources().getColor(R.color.black));
                tvSemanalPago.setTextColor(context.getResources().getColor(R.color.black));
                tvFechaPago.setTextColor(context.getResources().getColor(R.color.black));
                tvPendiente.setTextColor(context.getResources().getColor(R.color.black));

                /*btnPagarConMulta.setVisibility(View.GONE);
                btnNoPagar.setVisibility(View.GONE);
                btnPagar.setVisibility(View.GONE);*/

            }
            else if(pagos.get(position).getStatus().equals("4")){

                if(pagos.get(position).isSelected()){
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                }else {
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.secondary));
                }

                tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvPendiente.setTextColor(context.getResources().getColor(R.color.white));

                /*btnPagarConMulta.setVisibility(View.GONE);
                btnNoPagar.setVisibility(View.GONE);
                btnPagar.setVisibility(View.GONE);*/

            }
            /*else if(pagos.get(position).getStatus().equals("-1")){

                if(pagos.get(position).isSelected()){
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
                }else {
                    pago_item_bg.setBackgroundColor(context.getResources().getColor(R.color.danger_custom));
                }

                tvSemanaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvSemanalPago.setTextColor(context.getResources().getColor(R.color.white));
                tvFechaPago.setTextColor(context.getResources().getColor(R.color.white));
                tvFolioPago.setTextColor(context.getResources().getColor(R.color.white));

                pago_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                    @Override
                    public boolean onLongClick(View view) {

                        String[] items = {"Pagar"};
                        final String[] selected = {""};

                        new MaterialAlertDialogBuilder(context)
                                .setTitle("Semana " + pagos.get(position).getSemana())
                                .setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                        if(selected[0].equals("Pagar")){
                                            Bundle args = new Bundle();
                                            String pagoJsonString = Utils.getGsonParser().toJson(pagos.get(position));
                                            args.putString("pago", pagoJsonString);

                                            Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                                    .navigate(R.id.nav_pagos_pagar, args);
                                        }
                                        else{
                                            noPagar(pagos.get(position).getId(), "0", pagos.get(position).getSemana());
                                        }
                                    }
                                })
                                .setSingleChoiceItems(items, -1, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                        selected[0] = items[i];
                                    }
                                })
                                .show();
                        return false;
                    }
                });

            }*/


        }

        private void pagar(String pago_id, String prestamo_id, String pago_recibido, String pago_multa,
                           String concepto, String fecha_pago, String folio, String tipo_pago )
        {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "pagar");
                data.put("pago_id", pago_id);
                data.put("prestamo_id", prestamo_id);
                data.put("pago_recibido", pago_recibido);
                data.put("pago_multa", pago_multa);
                data.put("concepto", concepto);
                data.put("fecha_pago", fecha_pago);
                data.put("folio", folio);
                data.put("tipo_pago", tipo_pago);

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {

                            try {
                                //String data = response.get("data").toString();

                                JSONArray data = (JSONArray) response.get("data");

                                Log.d("dat", data.toString());


                            } catch (JSONException e) {
                                e.printStackTrace();
                            }

                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, context);

                }
            }) ;

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }

        private void noPagar(String pago_id, String pago_multa, String semana )
        {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "noPagar");
                data.put("pago_id", pago_id);
                data.put("pago_multa", pago_multa);
                data.put("semana", semana);

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {

                            try {
                                String data = response.get("data").toString();

                                Toast.makeText(context, "Pago no recibido", Toast.LENGTH_SHORT).show();

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }

                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, context);

                }
            }) ;

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
    }
}
